# USAGE
# python All_Disasters.py --video images/fire.mp4 --size "(350, 350)"

# import the necessary packages
import numpy as np
from tensorflow.keras.preprocessing.image import img_to_array
from imutils.object_detection import non_max_suppression
from utils.detection_helpers import sliding_window
from utils.detection_helpers import image_pyramid
from keras.models import load_model
import argparse
import cv2
import imutils
import time
import os
from PIL import Image, ImageOps

# construct the argument parse and parse the arguments
ap = argparse.ArgumentParser()
ap.add_argument("-m", "--model", required=False,
                help="path to pre-trained model")
ap.add_argument("-v", "--video", required=True,
                help="path to the input video")
ap.add_argument("-s", "--size", type=str, default="(200, 150)",
                help="ROI size (in pixels)")
ap.add_argument("-o", "--output", type=str, default="output.avi",
                help="output video filename")
ap.add_argument("-c", "--min-conf", type=float, default=0.99,
                help="minimum probability to filter weak detections")
#CHANGE THE UP IN CASE U WANT DIFFERENT CONFIGURATION
ap.add_argument("-v", "--visualize", type=int, default=-1,
                help="whether or not to show extra visualizations for debugging")
args = vars(ap.parse_args())

# initialize the class labels

labels = {0: 'General',
          1: 'Fire',
          2: 'Flood',
          3: 'Building-Disaster'} # new.h5


# initialize variables used for the object detection procedure
PYR_SCALE = 1.5
WIN_STEP = 100
ROI_SIZE = eval(args["size"])
INPUT_SIZE = (1024, 520)
MODEL_SIZE = (224, 224)
vidcap = cv2.VideoCapture(args["video"])
success, image = vidcap.read()
orig = cv2.resize(image, INPUT_SIZE)
# orig = imutils.resize(image, width=WIDTH)
(H, W) = orig.shape[:2]
frame_width = W
frame_height = H
frame_num = 0
# Define the codec and create VideoWriter object.The output is stored in 'outpy.avi' file.
out = cv2.VideoWriter(args['output'], cv2.VideoWriter_fourcc('M', 'J', 'P', 'G'), 30, (frame_width, frame_height))

print("[INFO] loading pre-trained network...")
model = load_model(args['model'], compile=False)

while (vidcap.isOpened()):
    success, frame = vidcap.read()
    if success:
        if frame_num%2==0:
            frame_num+=1
            continue
        orig = cv2.resize(frame, INPUT_SIZE)

        # initialize the image pyramid
        pyramid = image_pyramid(orig, scale=PYR_SCALE, minSize=ROI_SIZE)
        # initialize two lists, one to hold the ROIs generated from the image
        # pyramid and sliding window, and another list used to store the
        # (x, y)-coordinates of where the ROI was in the original image
        rois = []
        locs = []

        # time how long it takes to loop over the image pyramid layers and
        # sliding window locations
        start = time.time()

        # loop over the image pyramid
        for image in pyramid:
            # determine the scale factor between the *original* image
            # dimensions and the *current* layer of the pyramid
            scale = W / float(image.shape[1])
            # for each layer of the image pyramid, loop over the sliding
            # window locations
            for (x, y, roiOrig) in sliding_window(image, WIN_STEP, ROI_SIZE):
                # scale the (x, y)-coordinates of the ROI with respect to the
                # *original* image dimensions
                x = int(x * scale)
                y = int(y * scale)
                w = int(ROI_SIZE[0] * scale)
                h = int(ROI_SIZE[1] * scale)

                # take the ROI and pre-process it so we can later classify
                # the region using Keras/TensorFlow
                roi = cv2.resize(roiOrig, MODEL_SIZE)
                roi = img_to_array(roi)
                # update our list of ROIs and associated coordinates
                rois.append(roi)
                locs.append((x, y, x + w, y + h))


        # show how long it took to loop over the image pyramid layers and
        # sliding window locations
        end = time.time()
        # print("[INFO] looping over pyramid/windows took {:.5f} seconds".format(
        #     end - start))

        print("[INFO] predicting...")
        rois = (np.array(rois, dtype="float32") / 127.0) -1

        start = time.time()

        preds = model.predict(rois)
        end = time.time()
        # print("[INFO] predicting ROIs took {:.5f} seconds".format(end - start))
        start = time.time()

        # labels (keys) to any ROIs associated with that label (values)
        labels_d = {}

        # loop over the predictions
        for (i, p) in enumerate(preds):

            # grab the prediction information for the current ROI
            pred = p
            prob = np.max(pred)
            # filter out weak detections by ensuring the predicted probability
            # is greater than the minimum probability
            if prob >= args["min_conf"]:
                # grab the bounding box associated with the prediction and
                # convert the coordinates
                count = 0
                for n in pred:
                    if n > 0.5:
                        count = count + 1
                if count == 1:
                    box = locs[i]
                    label = labels[np.argmax([pred])]

                    # grab the list of predictions for the label and add the
                    # bounding box and probability to the list
                    L = labels_d.get(label, [])
                    L.append((box, prob))
                    labels_d[label] = L

        i = 0
        clone = orig.copy()
        # loop over the labels for each of detected objects in the image
        for label in labels_d.keys():
            if label == 'General':
                continue
            # extract the bounding boxes and associated prediction
            # probabilities, then apply non-maxima suppression
            boxes = np.array([p[0] for p in labels_d[label]])
            proba = np.array([p[1] for p in labels_d[label]])
            boxes = non_max_suppression(boxes, proba, 0.2)

            # loop over all bounding boxes that were kept after applying
            # non-maxima suppression
            for (startX, startY, endX, endY) in boxes:
                # draw the bounding box and label on the image
                cv2.rectangle(clone, (startX, startY), (endX, endY),
                              (0, 255, 0), 2)
                y = startY - 10 if startY - 10 > 10 else startY + 10
                cv2.putText(clone, label, (startX, y),
                            cv2.FONT_HERSHEY_SIMPLEX, 0.45, (0, 255, 0), 2)

        end = time.time()
        # print("[INFO] NMS took {:.5f} seconds".format(end - start))
                # show the output after apply non-maxima suppression
        # exit()
        if args['visualize']>0:
            cv2.imshow('frame', clone)
            if cv2.waitKey(1) & 0xFF == 27:
                break
        out.write(clone)

        i = i + 1
        frame_num = frame_num + 1

vidcap.release()
out.release()




